local c;
local player = Var "Player";
local ShowComboAt = THEME:GetMetric("Combo", "ShowComboAt");
local Pulse = THEME:GetMetric("Combo", "PulseCommand");

local comboColors = {
	FullComboW1 = color("#00AEEF"),
	FullComboW2 = color("#FFF568"),
	FullComboW3 = color("#A4FF00")
}

local t = Def.ActorFrame {
	InitCommand=cmd(valign,1);
	LoadFont("_loaded 32px") .. {
		Name="Number";
		OnCommand = THEME:GetMetric("Combo", "NumberOnCommand");
	};

	InitCommand = function(self)
		c = self:GetChildren();
		c.Number:visible(false);
	end;

	ComboCommand=function(self, param)
		local iCombo = param.Combo;
		if not iCombo or iCombo < ShowComboAt then
			c.Number:visible(false);
			return;
		end

		c.Number:visible(true);

		local targetColor;
		if param.FullComboW1 then
			targetColor = comboColors.FullComboW1
		elseif param.FullComboW2 then
			targetColor = comboColors.FullComboW2
		elseif param.FullComboW3 then
			targetColor = comboColors.FullComboW3
		elseif param.Combo then -- normal combo
			targetColor = color("#FFFFFF")
		else -- miss combo
			targetColor = color("#FF0000")
		end
		c.Number:diffuse( targetColor )

		c.Number:settext( string.format("%i", iCombo) );
	end;
};

return t;